
import javax.swing.*;
import java.awt.event.*;
import java.util.*;
import java.awt.*;

public class SLinkedListView
    extends  JFrame 
    implements ActionListener
{
    private SLinkedList1 slist = new SLinkedList1();
    private JLabel count;
    private JTextField item;
    
    ListIteratorView iterView;
    Screen screen;
    int number=0;
    private Container container;

    public SLinkedListView()
    {
        setSize(960,600);
        setDefaultCloseOperation( EXIT_ON_CLOSE );
        container=getContentPane();         
        container.setLayout(new BorderLayout());
       
        screen=new Screen(this);
        screen.setDrawMode("drawNumber");
        screen.repaint();  
        container.add( screen, BorderLayout.CENTER );
        JPanel buttons = new JPanel();
        
        JButton clearBtn = new JButton( "clear" );
        buttons.add( clearBtn );
        clearBtn.addActionListener( this );
        
        JButton prependBtn = new JButton( "add first" );
        buttons.add( prependBtn );
        prependBtn.addActionListener( this );
        
        JButton appendBtn = new JButton( "add last" );
        buttons.add( appendBtn );
        appendBtn.addActionListener( this );
        
        JButton containsBtn = new JButton( "contains" );
        buttons.add( containsBtn );
        containsBtn.addActionListener( this );
        
        JButton remove1stBtn = new JButton( "remove first" );
        buttons.add( remove1stBtn );
        remove1stBtn.addActionListener( this );
        
        JButton removeBtn = new JButton( "remove" );
        buttons.add( removeBtn );
        removeBtn.addActionListener( this );
        
        JButton iteratorBtn = new JButton( "listIterator" );
        buttons.add( iteratorBtn );
        iteratorBtn.addActionListener( this );
        
        JButton closeBtn = new JButton( "close" );
        buttons.add( closeBtn );
        closeBtn.addActionListener( this );
        
        JLabel blank = new JLabel( "     " );
        buttons.add( blank );
        JButton doubleBtn = new JButton( "double" );
        doubleBtn.setForeground( Color.red );
/*        buttons.add( doubleBtn );
        doubleBtn.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent e )
            {
                resumeListView();
                screen.setDrawMode("drawNumber");
                screen.repaint();
            }
        } );
*/        
        container.add( buttons, BorderLayout.NORTH ); 
        
        JLabel countLabel = new JLabel( "Count:" );
             
        count = new JLabel( "0", JLabel.RIGHT );
               
        JPanel inputPanel = new JPanel();
        inputPanel.add( countLabel );
        inputPanel.add( count  );
        JLabel itemLabel = new JLabel( "Item:" );
        inputPanel.add( itemLabel );
        
        item = new JTextField( 20 );       
        inputPanel.add( item );
         
        container.add( inputPanel, BorderLayout.SOUTH );
        item.setRequestFocusEnabled( true );
        addWindowListener( new WindowAdapter()
        {
            public void windowActivated( WindowEvent e )
            {
                resumeListView();
            }
        } );
        
        setVisible(true);
    }
	
    public void actionPerformed( ActionEvent e )
    {
        String command = e.getActionCommand();
        
        if ( command.equals( "clear" ) )
            doClear();
        else if ( command.equals( "add first" ) )
            doAddFirst();
        else if ( command.equals( "add last" ) )
            doAddLast();
        else if ( command.equals( "contains" ) )
            doContains();
        else if ( command.equals( "remove first" ) )
            doRemoveFirst();
        else if ( command.equals( "remove" ) )
            doRemove();
        else if ( command.equals( "listIterator" ) )
            doIterator();
        else if ( command.equals( "close" ) )
            doClose();
      
        updateView();
    }
    
    private void doClear()
    {
        resumeListView();
        slist.clear();
        screen.setDrawMode("drawNumber");
        screen.repaint();  
    }
    
    private void doAddFirst()
    {        
       String inp=item.getText();
       int theInt;
       try
       {
           theInt = Integer.parseInt( inp );
       }
       catch (NumberFormatException e )
       {
           item.setText( "input a number" );
           return;
       }
       selectItem();
       slist.addFirst(new Integer(theInt));        	
       screen.setDrawMode("drawNumber");
       screen.repaint();
    }
    
    private void doAddLast()
    {     
       String inp=item.getText();
       int theInt;
       try
       {
           theInt = Integer.parseInt( inp );
       }
       catch (NumberFormatException e )
       {
           item.setText( "input a number" );
           return;
       }
       selectItem();
       slist.addLast(new Integer(theInt));        	
       screen.setDrawMode("drawNumber");
       screen.repaint();
    }
    
    private void doContains()
    {
        try{
        if ( slist.contains(new Integer( item.getText() ) ))
            item.setText( "TRUE" );
        else
            item.setText( "FALSE" );
        }
        catch(NumberFormatException nf)
        {
            item.setText( "input a number" );
        }
        selectItem();
    }
    
    private void doRemoveFirst()
    {
        try
        {
            item.setText( slist.removeFirst().toString());
        }
        catch ( NoSuchElementException e )
        {
            Toolkit.getDefaultToolkit().beep();
        }
        selectItem();
        screen.setDrawMode("drawNumber");
        screen.repaint();  
    }
    
    private void doRemove()
    {
        try{
          if ( slist.remove( new Integer(item.getText()) ) )
            item.setText( "TRUE" );
          else
            item.setText( "FALSE" );
        }
        catch(NumberFormatException nf)
        {
            item.setText( "input a number" );
        }
        selectItem();
        screen.setDrawMode("drawNumber");
        screen.repaint();  
    }
    
    private void doIterator()
    {
        ListIterator iter = slist.listIterator();
        iterView = new ListIteratorView( iter, this,screen );     
        iterView.setVisible( true );
        screen.startIter(1);
        screen.setDrawMode("drawNumber");
        screen.repaint();                
    }
    
     
    private void doClose()
    {
        setVisible( false );
        System.exit( 0 );
    }
    public void updateView()
    {
        count.setText( String.valueOf( slist.size() ));
    }
    
    public void updatePosition(String a)
    {
        item.setText(a);
    }
    
    public SLinkedList1 getList()
    {
        return slist;
    }
    
    void resumeListView()
    {
        if(iterView!=null)
        {
           iterView.dispose();
           iterView=null;
        }
        screen.startIter(0);
        screen.repaint();
        screen.resetK();
        item.setText( "input a number" );
        selectItem();
    }
    
    private void selectItem( )
    {
        item.requestFocus();
        item.selectAll();
    }
}